/*
 * Decompiled with CFR 0.152.
 */
package com.inverze.util;

import java.text.DecimalFormat;

public class NumberToWords {
    private final String[] tens = new String[]{"", " ten", " twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety"};
    private final String[] numbers = new String[]{"", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};

    private String convertNumberLessThanOneThousand(int number) {
        String rest;
        if (number % 100 < 20) {
            rest = this.numbers[number % 100];
            number /= 100;
        } else {
            rest = this.numbers[number % 10];
            rest = this.tens[(number /= 10) % 10] + rest;
            number /= 10;
        }
        if (number == 0) {
            return rest;
        }
        return this.numbers[number] + " hundred" + rest;
    }

    public String convertNumber(double amount) {
        int dollars = (int)Math.rint(amount * 100.0);
        int fullDollars = dollars / 100;
        int decimalPoint = dollars % 100;
        return this.numberToWordFormat(fullDollars) + this.decimalCentsToWordFormat(decimalPoint, true);
    }

    public String decimalCentsToWordFormat(long number, boolean isBlank) {
        String strDecimal = this.numberToWordFormat(number);
        if (strDecimal.equals("zero")) {
            if (isBlank) {
                return "";
            }
            return " and zeco cents";
        }
        return " and " + strDecimal + " cents";
    }

    public String numberToWordFormat(long number) {
        String hundredThousandsString;
        String millionsString;
        String billionsString;
        if (number == 0L) {
            return "zero";
        }
        String snumber = Long.toString(number);
        String zeroMask = "000000000000";
        DecimalFormat df = new DecimalFormat(zeroMask);
        snumber = df.format(number);
        int billions = Integer.parseInt(snumber.substring(0, 3));
        int millions = Integer.parseInt(snumber.substring(3, 6));
        int hundredThousands = Integer.parseInt(snumber.substring(6, 9));
        int thousands = Integer.parseInt(snumber.substring(9, 12));
        switch (billions) {
            case 0: {
                billionsString = "";
                break;
            }
            case 1: {
                billionsString = this.convertNumberLessThanOneThousand(billions) + " billion ";
                break;
            }
            default: {
                billionsString = this.convertNumberLessThanOneThousand(billions) + " billion ";
            }
        }
        String result = billionsString;
        switch (millions) {
            case 0: {
                millionsString = "";
                break;
            }
            case 1: {
                millionsString = this.convertNumberLessThanOneThousand(millions) + " million ";
                break;
            }
            default: {
                millionsString = this.convertNumberLessThanOneThousand(millions) + " million ";
            }
        }
        result = result + millionsString;
        switch (hundredThousands) {
            case 0: {
                hundredThousandsString = "";
                break;
            }
            case 1: {
                hundredThousandsString = "one thousand ";
                break;
            }
            default: {
                hundredThousandsString = this.convertNumberLessThanOneThousand(hundredThousands) + " thousand ";
            }
        }
        result = result + hundredThousandsString;
        String thousandString = this.convertNumberLessThanOneThousand(thousands);
        result = result + thousandString;
        return result.replaceAll("^\\s+", "").replaceAll("\\b\\s{2,}\\b", " ");
    }
}

